﻿Imports System.ComponentModel
Imports FluentValidation
Imports FluentValidation.Results

Partial Friend NotInheritable Class MySettings : Implements IDataErrorInfo

    Public ReadOnly Property [Error] As String Implements System.ComponentModel.IDataErrorInfo.Error
        Get
            Return ValidationHelper.GetError(SelfValidate())
        End Get
    End Property

    'Rename to Items
    Public ReadOnly Property Items(columnName As String) As String Implements IDataErrorInfo.Item
        Get
            Dim __ValidationResults = SelfValidate()
            If __ValidationResults Is Nothing Then
                Return String.Empty
            End If
            Dim __ColumnResults = __ValidationResults.Errors.FirstOrDefault(Function(x) String.Compare(x.PropertyName, columnName, True) = 0)
            Return If(__ColumnResults IsNot Nothing, __ColumnResults.ErrorMessage, String.Empty)
        End Get

    End Property

    Public Function SelfValidate() As ValidationResult
        Dim v = ValidationHelper.Validate(Of SettingsValidator, MySettings)(Me)
        IsValid = v.IsValid
        Return v
    End Function

    Private _isValid As Boolean
    Public Property IsValid As Boolean
        Get
            Return _isValid
        End Get
        Set(ByVal Value As Boolean)
            If Value = _isValid Then Return
            _isValid = Value
            'raises onpropertychanged event to update UI
            OnPropertyChanged(Me, New PropertyChangedEventArgs("IsValid"))
        End Set
    End Property

End Class

Friend Class SettingsValidator
    Inherits AbstractValidator(Of MySettings)

    Public Sub New()
        'use regex to validate IP Setting
        RuleFor(Function(S) (S.PLCIP)).
               NotEmpty.
               Matches("(?<First>2[0-4]\d|25[0-5]|[01]?\d\d?)\." &
                       "(?<Second>2[0-4]\d|25[0-5]|[01]?\d\d?)\." &
                       "(?<Third>2[0-4]\d|25[0-5]|[01]?\d\d?)\." &
                       "(?<Fourth>2[0-4]\d|25[0-5]|[01]?\d\d?)").
                   WithMessage("IP Address for the PLC is not valid")

        RuleFor(Function(s) (s.ScanInterval)).
            NotNull.
            InclusiveBetween(200, 1200)

        'Set 2 rules for each variable. One to check range and the other to make sure they are unique
        RuleFor(Function(s) (s.SetVariable)).
            NotNull.InclusiveBetween(1, 200)

        RuleFor(Function(s) (s.SetVariable)).
            NotEqual(Function(s) (s.ResetVariable)).
            WithMessage("This variable number is already being used")

        RuleFor(Function(s) (s.ResetVariable)).
            NotNull.
            InclusiveBetween(1, 200)

        RuleFor(Function(s) (s.ResetVariable)).
            NotEqual(Function(s) (s.SetVariable)).
            WithMessage("This variable number is already being used")

    End Sub


End Class
