Imports System.ComponentModel
Imports FluentValidation
Imports FluentValidation.Results
Imports System.Text

Public Class ValidationHelper
    'http://blogsprajeesh.blogspot.com/2009/11/fluent-validation-wpf-implementation.html
    Public Shared Function Validate(Of T As {IValidator(Of K), New}, K As Class)(entity As K) As ValidationResult
        Try
            Dim __Validator As IValidator(Of K) = New T()

            Return __Validator.Validate(entity)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Function

    Public Shared Function GetError(result As ValidationResult) As String
        Dim __ValidationErrors = New StringBuilder()
        For Each validationFailure In result.Errors
            __ValidationErrors.Append(validationFailure.ErrorMessage)
            __ValidationErrors.Append(Environment.NewLine)
        Next
        Return __ValidationErrors.ToString()
    End Function
End Class